Public Delegate Function MyFxDelegate(ByVal nNumVars As Integer, ByRef fX() As Double, ByRef fParam() As Double) As Double
Public Delegate Function SayFxDelegate() As String

Public Class CRandomSearch3

  Public Function CalcOptim(ByVal nNumVars As Integer, ByRef fX() As Double, ByRef fParam() As Double, _
                            ByRef fRadius() As Double, ByVal nMaxIter As Integer, ByVal EpsFx As Double, _
                            ByRef nIter As Integer, ByVal MyFx As MyFxDelegate) As Double

    Dim F, fBestF, fBestX(), fLastBestF As Double
    Dim I As Integer

    ReDim fBestX(nNumVars)

    For I = 0 To nNumVars - 1
      fBestX(I) = fX(I)
    Next
    ' calculate and display function value at initial point
    fBestF = MyFx(nNumVars, fBestX, fParam)
    If fBestF > 0 Then
      fLastBestF = fBestF + 100
    Else
      fLastBestF = 100 - fBestF
    End If

    nIter = 0
    Do
      nIter += 1
      If nIter > nMaxIter Then Exit Do
      Randomize(Timer)
      For I = 0 To nNumVars - 1
        fX(I) = fBestX(I) + (Rnd(1) - 0.5) * fRadius(I)
      Next
      F = MyFx(nNumVars, fX, fParam)
      If F < fBestF Then
        For I = 0 To nNumVars - 1
          fBestX(I) = fX(I)
        Next
        fBestF = F

        ' test function value convergence
        If Math.Abs(fBestF - fLastBestF) < EpsFx Then Exit Do
        fLastBestF = fBestF
      End If
    Loop

    Return fBestF

  End Function
End Class

