using System.Diagnostics;
using System.Data;
using System.Collections;
using Microsoft.VisualBasic;
using System.Collections.Generic;
using System;

namespace Optim_SteepestDescent1
{
	sealed class Module1
	{
		
		static public void Main()
		{
			int nNumVars = 2;
			double[] fX = new double[] { 0, 0 };
			double[] fParam = new double[] { 0, 0 };
			int nIter = 0;
			int nMaxIter = 100;
			double fEpsFx = 0.0000001;
			int i;
			object fBestF;
			string sAnswer;
			string sErrorMsg = "";
			CSteepestDescent1 oOpt;
			MyFxDelegate MyFx = new MyFxDelegate(Fx3);
			SayFxDelegate SayFx = new SayFxDelegate(SayFx3);
			
			oOpt = new CSteepestDescent1();
			
			Console.WriteLine("Steepest Descent Optimization");
			Console.WriteLine("Finding the minimum of function:");
			Console.WriteLine(SayFx());
			Console.Write("Use default input values? (Y/N) ");
			sAnswer = Console.ReadLine();
			if (sAnswer.ToUpper() == "Y")
			{
				for (i = 0; i < nNumVars; i++)
				{
					Console.WriteLine("X({0}) = {1}", i + 1, fX[i]);
				}
				Console.WriteLine("Function tolerance = {0}", fEpsFx);
				Console.WriteLine("Maxumum cycles = {0}", nMaxIter);
			}
			else
			{
				for (i = 0; i < nNumVars; i++)
				{
					fX[i] = GetIndexedDblInput("X", i + 1, fX[i]);
				}
				fEpsFx = GetDblInput("Function tolerance", fEpsFx);
				nMaxIter =  (int) GetDblInput("Maxumum cycles", nMaxIter);
			}
			
			Console.WriteLine("******** FINAL RESULTS *************");
			fBestF = oOpt.CalcOptim(nNumVars, ref fX, ref fParam, fEpsFx, nMaxIter, ref nIter, ref sErrorMsg, MyFx);
			if (sErrorMsg.Length > 0)
			{
				Console.WriteLine("** NOTE: {0} ***", sErrorMsg);
			}
			Console.WriteLine("Optimum at");
			for (i = 0; i < nNumVars; i++)
			{
				Console.WriteLine("X({0}) = {1}", i + 1, fX[i]);
			}
			Console.WriteLine("Function value = {0}", fBestF);
			Console.WriteLine("Number of iterations = {0}", nIter);
			Console.WriteLine();
			Console.Write("Press Enter to end the program ...");
			Console.ReadLine();
		}
        static public double GetDblInput(string sPrompt, double fDefInput)
        {
            string sInput;

            Console.Write("{0}? ({1}): ", sPrompt, fDefInput);
            sInput = Console.ReadLine();
            if (sInput.Trim(null).Length > 0)
            {
                return double.Parse(sInput);
            }
            else
            {
                return fDefInput;
            }
        }

        static public int GetIntInput(string sPrompt, int nDefInput)
        {
            string sInput;

            Console.Write("{0}? ({1}): ", sPrompt, nDefInput);
            sInput = Console.ReadLine();
            if (sInput.Trim(null).Length > 0)
            {
                return int.Parse(sInput);
            }
            else
            {
                return nDefInput;
            }
        }

        static public double GetIndexedDblInput(string sPrompt, int nIndex, double fDefInput)
        {
            string sInput;

            Console.Write("{0}({1})? ({2}): ", sPrompt, nIndex, fDefInput);
            sInput = Console.ReadLine();
            if (sInput.Trim(null).Length > 0)
            {
                return double.Parse(sInput);
            }
            else
            {
                return fDefInput;
            }
        }

        static public int GetIndexedIntInput(string sPrompt, int nIndex, int nDefInput)
        {
            string sInput;

            Console.Write("{0}({1})? ({2}): ", sPrompt, nIndex, nDefInput);
            sInput = Console.ReadLine();
            if (sInput.Trim(null).Length > 0)
            {
                return int.Parse(sInput);
            }
            else
            {
                return nDefInput;
            }
        }

        static public string SayFx1()
        {
            return "F(X) = 10 + (X(1) - 2) ^ 2 + (X(2) + 5) ^ 2";
        }

        static public double Fx1(int N, ref double[] X, ref double[] fParam)
        {
            return 10 + Math.Pow(X[0] - 2, 2) + Math.Pow(X[1] + 5, 2);
        }

        static public string SayFx2()
        {
            return "F(X) = 100 * (X(1) - X(2) ^ 2) ^ 2 + (X(2) - 1) ^ 2";
        }

        static public double Fx2(int N, ref double[] X, ref double[] fParam)
        {
            return Math.Pow(100 * (X[0] - X[1] * X[1]), 2) + Math.Pow((X[1] - 1), 2);
        }

        static public string SayFx3()
        {
            return "F(X) = X(1) - X(2) + 2 * X(1) ^ 2 + 2 * X(1) * X(2) + X(2) ^ 2";
        }

        static public double Fx3(int N, ref double[] X, ref double[] fParam)
        {
            return X[0] - X[1] + 2 * X[0] * X[0] + 2 * X[0] * X[1] + X[1] * X[1];
        }		
	}
	
}
