using System.Diagnostics;
using System.Data;
using System.Collections;
using Microsoft.VisualBasic;
using System.Collections.Generic;
using System;

namespace Optim_SteepestDescent1
{
	public delegate double MyFxDelegate(int nNumVars, ref double[] fX, ref double[] fParam);
	public delegate string SayFxDelegate();
	
	public class CSteepestDescent1
	{
		
		
		MyFxDelegate m_MyFx;
		
		
		public double MyFxEx(int nNumVars, ref double[] fX, ref double[] fParam, ref double[] fDeltaX, double fLambda)
		{
			int i;
			double[] fXX = new double[nNumVars];
			
			for (i = 0; i < nNumVars; i++)
			{
				fXX[i] = fX[i] + fLambda * fDeltaX[i];
			}
            return m_MyFx(nNumVars, ref fXX, ref fParam);
		}
		
		private void GetGradients(int nNumVars, ref double[] fX, ref double[] fParam, ref double[] fDeriv, ref double fDerivNorm)
		{
			
			int i;
			double fXX, H, Fp, Fm;
			
			fDerivNorm = 0;
			for (i = 0; i < nNumVars; i++)
			{
				fXX = fX[i];
				H = 0.01 *(1 + Math.Abs(fXX));
				fX[i] = fXX + H;
                Fp = m_MyFx(nNumVars, ref fX, ref fParam);
				fX[i] = fXX - H;
                Fm = m_MyFx(nNumVars, ref fX, ref fParam);
				fX[i] = fXX;
				fDeriv[i] = (Fp - Fm) / 2 / H;
				fDerivNorm += Math.Pow(fDeriv[i], 2);
			}
			fDerivNorm = Math.Sqrt(fDerivNorm);
		}
		
		public bool LinSearch_DirectSearch(int nNumVars, ref double[] fX, ref double[] fParam, ref double fLambda, ref double[] fDeltaX, double InitStep, double MinStep)
		{
			double F1;
			double F2;
			
            F1 = MyFxEx(nNumVars, ref fX, ref fParam, ref fDeltaX, fLambda);
			
			do
			{
                F2 = MyFxEx(nNumVars, ref fX, ref fParam, ref fDeltaX, fLambda + InitStep);
				if (F2 < F1)
				{
					F1 = F2;
					fLambda += InitStep;
				}
				else
				{
					object temp_object3 = fX;
					double[] temp_double3 =  (double[]) temp_object3;
					object temp_object6 = fParam;
					double[] temp_double6 =  (double[]) temp_object6;
					object temp_object9 = fDeltaX;
					double[] temp_double9 =  (double[]) temp_object9;
                    F2 = MyFxEx(nNumVars, ref fX, ref fParam, ref fDeltaX, fLambda - InitStep);
					if (F2 < F1)
					{
						F1 = F2;
						fLambda -= InitStep;
					}
					else
					{
						// reduce search step size
						InitStep /= 10;
					}
				}
			} while (!(InitStep < MinStep));
			
			return true;
			
		}
		
		
		public double CalcOptim(int nNumVars, ref double[] fX, ref double[] fParam, double fEpsFx, int nMaxIter, ref int nIter, ref string sErrorMsg, MyFxDelegate MyFx)
		{
			
			int i;
			double[] fDeriv = new double[nNumVars + 1];
			double[] fDerivOld = new double[nNumVars + 1];
			double F;
			double fDFNorm = 0;
			// 			double fDFNorm;
			double fLambda, fLastF;
			
			m_MyFx = MyFx;
			

            fLastF = MyFx(nNumVars, ref fX, ref fParam);
			sErrorMsg = "";
			nIter = 1;
			do
			{
				nIter++;
				if (nIter > nMaxIter)
				{
					sErrorMsg = "Reached maximum iterations limit";
					break;
				}

                GetGradients(nNumVars, ref fX, ref fParam, ref fDeriv, ref fDFNorm);
				
				if (fDFNorm <= fEpsFx)
				{
					sErrorMsg = "Gradient norm meets convergence criteria";
					break;
				}
				for (i = 0; i < nNumVars; i++)
				{
					fDeriv[i] = - fDeriv[i] / fDFNorm;
				}
				fLambda = 0.1;
                if (LinSearch_DirectSearch(nNumVars, ref fX, ref fParam, ref fLambda, ref fDeriv, 0.1, 0.000001))
				{
					for (i = 0; i < nNumVars; i++)
					{
						fX[i] += fLambda * fDeriv[i];
					}
                    F = MyFx(nNumVars, ref fX, ref fParam);
					if (Math.Abs(F - fLastF) < fEpsFx)
					{
						sErrorMsg = "Successive function values meet convergence criteria";
						break;
					}
					else
					{
						fLastF = F;
					}
					
				}
				else
				{
					sErrorMsg = "Failed linear search";
					break;
				}
			} while (true);
			
			return fLastF;
			
		}
		
	}
	
}
